/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.clazz.AnnotationNamesProvider;
import org.javers.core.metamodel.property.FieldProperty;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;

public class FieldBasedPropertyScanner
implements PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public FieldBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public List<Property> scan(Class<?> managedClass) {
        List<Field> fields = ReflectionUtil.getAllPersistentFields(managedClass);
        ArrayList<Property> propertyList = new ArrayList<Property>(fields.size());
        for (Field field : fields) {
            if (ReflectionUtil.hasAnyAnnotation(field, this.annotationNamesProvider.getTransientAliases())) continue;
            FieldProperty fieldProperty = new FieldProperty(field);
            propertyList.add(fieldProperty);
        }
        return propertyList;
    }
}

