/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.ClientsDomainClass;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClassFactory;
import org.javers.core.metamodel.clazz.Value;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;

public class TypeFactory {
    private final ManagedClassFactory managedClassFactory;

    public TypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    JaversType createFromDefinition(ClientsClassDefinition def) {
        return this.createFromClientsClass(this.managedClassFactory.create(def));
    }

    JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            return ((ManagedType)prototype).spawn(javaClass, this.managedClassFactory);
        }
        return prototype.spawn(javaType);
    }

    public JaversType inferFromAnnotations(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        return this.createFromClientsClass(this.managedClassFactory.inferFromAnnotations(javaClass));
    }

    private JaversType createFromClientsClass(ClientsDomainClass clientsClass) {
        if (clientsClass instanceof Value) {
            return new ValueType(clientsClass.getClientsClass());
        }
        if (clientsClass instanceof ValueObject) {
            return new ValueObjectType((ValueObject)clientsClass);
        }
        if (clientsClass instanceof Entity) {
            return new EntityType((Entity)clientsClass);
        }
        throw new IllegalArgumentException("unsupported " + clientsClass.getName());
    }
}

