/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ArgumentResolver;
import org.javers.common.validation.Validate;

public class ReflectionUtil {
    public static final String ID_ANN = "Id";
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object newInstance(Class clazz, ArgumentResolver resolver) {
        Validate.argumentIsNotNull(clazz);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (ReflectionUtil.isPrivate(constructor)) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Object[] params = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                params[i] = resolver.resolve(types[i]);
            }
            try {
                constructor.setAccessible(true);
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new JaversException(JaversExceptionCode.NO_PUBLIC_CONSTRUCTOR, clazz.getName());
    }

    public static List<Field> getAllPersistentFields(Class methodSource) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : ReflectionUtil.getAllFields(methodSource)) {
            if (!ReflectionUtil.isPersistentField(field)) continue;
            result.add(field);
        }
        return result;
    }

    public static List<Method> findAllPersistentGetters(Class methodSource) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : ReflectionUtil.getAllMethods(methodSource)) {
            if (!ReflectionUtil.isPersistentGetter(m)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Method> getAllMethods(Class methodSource) {
        ArrayList<Method> methods = new ArrayList<Method>();
        HashSet<Integer> added = new HashSet<Integer>();
        for (Class clazz = methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                int methodKey = ReflectionUtil.methodKey(m);
                if (added.contains(methodKey)) continue;
                methods.add(m);
                added.add(methodKey);
            }
        }
        return methods;
    }

    public static List<Field> getAllFields(Class<?> methodSource) {
        List<Field> fields = Lists.asList(methodSource.getDeclaredFields());
        if (methodSource.getSuperclass() != Object.class) {
            fields.addAll(ReflectionUtil.getAllFields(methodSource.getSuperclass()));
        }
        return fields;
    }

    private static int methodKey(Method m) {
        int key = ReflectionUtil.shaDigest(m.getName());
        for (Class<?> c : m.getParameterTypes()) {
            key += c.hashCode();
        }
        return key;
    }

    public static boolean isPersistentGetter(Method m) {
        if (!ReflectionUtil.isGetter(m)) {
            return false;
        }
        return !Modifier.isStatic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers()) && !Modifier.isNative(m.getModifiers());
    }

    public static boolean isPersistentField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("this$0");
    }

    public static boolean isAnnotationPresent(AccessibleObject methodOrField, String annotationName) {
        Validate.argumentsAreNotNull(methodOrField, annotationName);
        return ReflectionUtil.contains(methodOrField.getAnnotations(), annotationName);
    }

    public static boolean hasAnyAnnotation(AccessibleObject methodOrField, Set<String> annotationNames) {
        for (String annotationName : annotationNames) {
            if (!ReflectionUtil.isAnnotationPresent(methodOrField, annotationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Annotation[] annotations, String annotationName) {
        for (Annotation a : annotations) {
            if (!a.annotationType().getSimpleName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGetter(Method m) {
        return (m.getName().substring(0, 3).equals("get") || m.getName().substring(0, 2).equals("is")) && m.getParameterTypes().length == 0;
    }

    public static String getterToField(Method getter) {
        if (getter.getName().substring(0, 3).equals("get")) {
            return getter.getName().substring(3, 4).toLowerCase() + getter.getName().substring(4);
        }
        if (getter.getName().substring(0, 2).equals("is")) {
            return getter.getName().substring(2, 3).toLowerCase() + getter.getName().substring(3);
        }
        throw new IllegalArgumentException("Method [" + getter + "] is not getter");
    }

    public static Object invokeGetter(Method getter, Object onObject) {
        try {
            return getter.invoke(onObject, EMPTY_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("error calling getter '" + getter + "'", e);
        }
    }

    public static Object invokeGetterEvenIfPrivate(Method getter, Object onObject) {
        ReflectionUtil.setAccessibleIfNecessary(getter);
        return ReflectionUtil.invokeGetter(getter, onObject);
    }

    public static Object invokeFieldEvenIfPrivate(Field field, Object onObject) {
        ReflectionUtil.setAccessibleIfNecessary(field);
        return ReflectionUtil.invokeField(field, onObject);
    }

    public static Object invokeField(Field field, Object onObject) {
        try {
            return field.get(onObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error getting value from field '" + field.getName() + "'", e);
        }
    }

    private static void setAccessibleIfNecessary(Member member) {
        if (!ReflectionUtil.isPublic(member)) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    private static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    private static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static List<Class> extractActualClassTypeArguments(Type javaType) {
        if (!(javaType instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)javaType;
        ArrayList<Class> result = new ArrayList<Class>();
        for (Type t : parameterizedType.getActualTypeArguments()) {
            if (!(t instanceof Class)) continue;
            result.add((Class)t);
        }
        return Collections.unmodifiableList(result);
    }

    public static Class extractClass(Type javaType) {
        if (javaType instanceof ParameterizedType && ((ParameterizedType)javaType).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)javaType).getRawType();
        }
        if (javaType instanceof Class) {
            return (Class)javaType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_EXTRACTION_ERROR, javaType);
    }

    public static int calculateHierarchyDistance(Class<?> clazz, Class<?> parent) {
        Class<?> current = clazz;
        int distance = 0;
        while (current != null) {
            if (parent == current) {
                return distance;
            }
            for (Class<?> interf : current.getInterfaces()) {
                if (parent != interf) continue;
                return distance + 1;
            }
            current = current.getSuperclass();
            ++distance;
        }
        return Integer.MAX_VALUE;
    }

    private static int shaDigest(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(text.getBytes("UTF-8"));
            byte[] hashBytes = digest.digest();
            int result = 0;
            for (int i = 0; i < hashBytes.length; ++i) {
                result += Math.abs(hashBytes[i]) * (i + 1);
            }
            return result;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

