/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.string;

import org.javers.common.validation.Validate;

public class ToStringBuilder {
    public static String toStringSimple(Object ... fieldsMap) {
        Validate.argumentCheck(fieldsMap.length % 2 == 0, "map expected");
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < fieldsMap.length; i += 2) {
            if (i == 0) {
                out.append(ToStringBuilder.addFirstField(fieldsMap[i] + "", fieldsMap[i + 1]));
                continue;
            }
            out.append(ToStringBuilder.addField(fieldsMap[i] + "", fieldsMap[i + 1]));
        }
        return out.toString();
    }

    public static String toString(Object instance, Object ... fieldsMap) {
        Validate.argumentIsNotNull(instance);
        return instance.getClass().getSimpleName() + "{" + ToStringBuilder.toStringSimple(fieldsMap) + "}";
    }

    public static String addField(String fieldName, Object value) {
        return ", " + ToStringBuilder.addFirstField(fieldName, value);
    }

    public static String addFirstField(String fieldName, Object value) {
        return fieldName + ":'" + (value != null ? value.toString() : "") + "'";
    }

    public static String addEnumField(String fieldName, Object value) {
        return ", " + fieldName + ":[" + (value != null ? value.toString() : "") + "]";
    }
}

