/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.IdBuilder;
import org.javers.core.changelog.ChangeListTraverser;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitFactory;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.snapshot.SnapshotDiffer;
import org.javers.repository.api.JaversExtendedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javers {
    private static final Logger logger = LoggerFactory.getLogger(Javers.class);
    private final DiffFactory diffFactory;
    private final TypeMapper typeMapper;
    private final JsonConverter jsonConverter;
    private final CommitFactory commitFactory;
    private final JaversExtendedRepository repository;
    private final SnapshotDiffer snapshotDiffer;

    public Javers(DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter, CommitFactory commitFactory, JaversExtendedRepository repository, SnapshotDiffer snapshotDiffer) {
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
        this.commitFactory = commitFactory;
        this.repository = repository;
        this.snapshotDiffer = snapshotDiffer;
    }

    public Commit commit(String author, Object currentVersion) {
        Commit commit = this.commitFactory.create(author, currentVersion);
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.diffFactory.compare(oldVersion, currentVersion);
    }

    public Diff initial(Object newDomainObject) {
        return this.diffFactory.initial(newDomainObject);
    }

    public String toJson(Diff diff) {
        return this.jsonConverter.toJson(diff);
    }

    public IdBuilder idBuilder() {
        return new IdBuilder(new GlobalIdFactory(this.typeMapper));
    }

    public List<CdoSnapshot> getStateHistory(GlobalIdDTO globalId, int limit) {
        return this.repository.getStateHistory(globalId, limit);
    }

    public Optional<CdoSnapshot> getLatestSnapshot(GlobalIdDTO globalId) {
        return this.repository.getLatest(globalId);
    }

    public List<Change> getChangeHistory(GlobalIdDTO globalId, int limit) {
        return this.snapshotDiffer.getChangeHistory(globalId, limit);
    }

    JaversType getForClass(Class<?> clazz) {
        return this.typeMapper.getJaversType(clazz);
    }

    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        ChangeListTraverser.traverse(changes, changeProcessor);
        return changeProcessor.result();
    }
}

