/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Collection;
import org.javers.core.json.JsonTypeAdapter;

public class JsonConverter {
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private Gson gson;
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    JsonConverter() {
    }

    void initialize() {
        this.gson = this.gsonBuilder.serializeNulls().setPrettyPrinting().setDateFormat(ISO_DATE_TIME_FORMAT).create();
    }

    void registerNativeGsonTypeAdapter(Type targetType, TypeAdapter nativeAdapter) {
        this.gsonBuilder.registerTypeAdapter(targetType, (Object)nativeAdapter);
    }

    void registerNativeGsonSerializer(Type targetType, JsonSerializer<?> jsonSerializer) {
        this.gsonBuilder.registerTypeAdapter(targetType, jsonSerializer);
    }

    void registerNativeGsonDeserializer(Type targetType, JsonDeserializer<?> jsonDeserializer) {
        this.gsonBuilder.registerTypeAdapter(targetType, jsonDeserializer);
    }

    void registerJsonTypeAdapters(Collection<JsonTypeAdapter> adapters) {
        for (JsonTypeAdapter adapter : adapters) {
            this.registerJsonTypeAdapter(adapter);
        }
    }

    void registerJsonTypeAdapter(JsonTypeAdapter adapter) {
        for (Class c : adapter.getValueTypes()) {
            this.registerJsonTypeAdapter(c, adapter);
        }
    }

    public String toJson(Object value) {
        this.checkState();
        return this.gson.toJson(value);
    }

    public JsonElement toJsonElement(Object value) {
        this.checkState();
        return this.gson.toJsonTree(value);
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        this.checkState();
        return (T)this.gson.fromJson(json, expectedType);
    }

    public <T> T fromJsonTree(JsonElement json, Class<T> expectedType) {
        this.checkState();
        return (T)this.gson.fromJson(json, expectedType);
    }

    private void checkState() {
        if (this.gson == null) {
            throw new IllegalStateException("JsonConverter not initialized");
        }
    }

    void registerJsonTypeAdapter(Type targetType, final JsonTypeAdapter adapter) {
        JsonSerializer jsonSerializer = new JsonSerializer(){

            public JsonElement serialize(Object value, Type type, JsonSerializationContext jsonSerializationContext) {
                return adapter.toJson(value, jsonSerializationContext);
            }
        };
        JsonDeserializer jsonDeserializer = new JsonDeserializer(){

            public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return adapter.fromJson(jsonElement, jsonDeserializationContext);
            }
        };
        this.registerNativeGsonSerializer(targetType, jsonSerializer);
        this.registerNativeGsonDeserializer(targetType, jsonDeserializer);
    }
}

