/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotBuilder {
    private final GlobalId globalId;
    private final Map<Property, Object> state = new HashMap<Property, Object>();
    private CommitMetadata commitMetadata;

    private CdoSnapshotBuilder(GlobalId globalId, CommitMetadata commitMetadata) {
        this.globalId = globalId;
        this.commitMetadata = commitMetadata;
    }

    public static CdoSnapshotBuilder cdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata) {
        Validate.argumentIsNotNull(globalId);
        return new CdoSnapshotBuilder(globalId, commitMetadata);
    }

    public CdoSnapshotBuilder withPropertyValue(Property property, Object value) {
        Validate.argumentIsNotNull(property);
        if (value == null) {
            return this;
        }
        if (this.state.containsKey(property)) {
            throw new JaversException(JaversExceptionCode.SNAPSHOT_STATE_VIOLATION, new Object[0]);
        }
        this.state.put(property, value);
        return this;
    }

    public CdoSnapshot build() {
        return new CdoSnapshot(this.globalId, this.commitMetadata, this.state);
    }

    public CdoSnapshotBuilder withCommitMetadata(CommitMetadata commitMetadata) {
        this.commitMetadata = commitMetadata;
        return this;
    }
}

