/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.InstanceIdDTO;
import org.javers.core.snapshot.GraphShadowFactory;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.repository.api.JaversExtendedRepository;

public class SnapshotDiffer {
    private final JaversExtendedRepository javersExtendedRepository;
    private final GraphShadowFactory graphShadowFactory;
    private final DiffFactory diffFactory;

    public SnapshotDiffer(JaversExtendedRepository javersExtendedRepository, GraphShadowFactory graphShadowFactory, DiffFactory diffFactory) {
        this.javersExtendedRepository = javersExtendedRepository;
        this.graphShadowFactory = graphShadowFactory;
        this.diffFactory = diffFactory;
    }

    public List<Change> getChangeHistory(Object localId, Class entityClass, int limit) {
        return this.getChangeHistory(InstanceIdDTO.instanceId(localId, entityClass), limit);
    }

    public List<Change> getChangeHistory(GlobalIdDTO globalCdoId, int limit) {
        Validate.argumentsAreNotNull(globalCdoId);
        List<CdoSnapshot> snapshots = this.javersExtendedRepository.getStateHistory(globalCdoId, limit);
        ArrayList<Change> result = new ArrayList<Change>();
        if (snapshots.size() > 1) {
            for (int i = 0; i < snapshots.size() - 1; ++i) {
                result.addAll(this.compare(snapshots.get(i + 1), snapshots.get(i)));
            }
        }
        this.addNewObjectIfInitial(result, snapshots.get(snapshots.size() - 1));
        return result;
    }

    private void addNewObjectIfInitial(List<Change> changes, CdoSnapshot first) {
        if (first.isInitial()) {
            Diff diff = this.diffFactory.create(ShadowGraph.EMPTY, this.fromSnapshot(first), Optional.of(first.getCommitMetadata()));
            changes.add(diff.getChangesByType(NewObject.class).get(0));
        }
    }

    private List<Change> compare(CdoSnapshot oldVer, CdoSnapshot newVer) {
        CommitMetadata commitMetadata = newVer.getCommitMetadata();
        Diff diff = this.diffFactory.create(this.fromSnapshot(oldVer), this.fromSnapshot(newVer), Optional.of(commitMetadata));
        return diff.getChanges();
    }

    private ShadowGraph fromSnapshot(CdoSnapshot snapshot) {
        return this.graphShadowFactory.createFromSnapshot(snapshot);
    }
}

