/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;

public final class CdoSnapshot
extends Cdo {
    private CommitMetadata commitMetadata;
    private final Map<Property, Object> state;
    private final SnapshotType type;

    CdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata, Map<Property, Object> state, SnapshotType type) {
        super(globalId);
        Validate.argumentsAreNotNull(new Object[]{state, commitMetadata, type});
        this.state = state;
        this.commitMetadata = commitMetadata;
        this.type = type;
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.empty();
    }

    public int size() {
        return this.state.size();
    }

    @Override
    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        Object val = this.state.get(property);
        if (val == null) {
            return Defaults.defaultValue(property.getType());
        }
        return val;
    }

    @Override
    public Object getPropertyValue(String withName) {
        Property property = this.getGlobalId().getCdoClass().getProperty(withName);
        return this.getPropertyValue(property);
    }

    @Override
    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return !this.state.containsKey(property);
    }

    public CommitId getCommitId() {
        return this.commitMetadata.getId();
    }

    public CommitMetadata getCommitMetadata() {
        return this.commitMetadata;
    }

    public boolean stateEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdoSnapshot other = (CdoSnapshot)o;
        return this.state.equals(other.state);
    }

    public Set<Property> getProperties() {
        return Collections.unmodifiableSet(this.state.keySet());
    }

    public boolean isInitial() {
        return this.type == SnapshotType.INITIAL;
    }

    public boolean isTerminal() {
        return this.type == SnapshotType.TERMINAL;
    }

    public SnapshotType getType() {
        return this.type;
    }
}

