/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.List;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.graph.LiveGraph;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.snapshot.GraphShadowFactory;
import org.javers.core.snapshot.GraphSnapshotFactory;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.core.snapshot.SnapshotDiffer;

public class GraphSnapshotFacade {
    private final SnapshotDiffer snapshotDiffer;
    private final GraphSnapshotFactory graphSnapshotFactory;
    private final GraphShadowFactory graphShadowFactory;

    public GraphSnapshotFacade(SnapshotDiffer snapshotDiffer, GraphSnapshotFactory graphSnapshotFactory, GraphShadowFactory graphShadowFactory) {
        this.snapshotDiffer = snapshotDiffer;
        this.graphSnapshotFactory = graphSnapshotFactory;
        this.graphShadowFactory = graphShadowFactory;
    }

    public List<Change> getChangeHistory(GlobalIdDTO globalId, int limit) {
        return this.snapshotDiffer.getChangeHistory(globalId, limit);
    }

    public ShadowGraph createLatestShadow(LiveGraph currentGraph) {
        return this.graphShadowFactory.createLatestShadow(currentGraph);
    }

    public List<CdoSnapshot> createGraphSnapshot(LiveGraph currentGraph, ShadowGraph latestShadowGraph, CommitMetadata commitMetadata) {
        return this.graphSnapshotFactory.create(currentGraph, latestShadowGraph, commitMetadata);
    }
}

