/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.IdBuilder;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeListTraverser;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitFactory;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.snapshot.GraphSnapshotFacade;
import org.javers.repository.api.JaversExtendedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaversCore
implements Javers {
    private static final Logger logger = LoggerFactory.getLogger(Javers.class);
    private final DiffFactory diffFactory;
    private final TypeMapper typeMapper;
    private final JsonConverter jsonConverter;
    private final CommitFactory commitFactory;
    private final JaversExtendedRepository repository;
    private final GraphSnapshotFacade graphSnapshotFacade;
    private final GlobalIdFactory globalIdFactory;

    JaversCore(DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter, CommitFactory commitFactory, JaversExtendedRepository repository, GraphSnapshotFacade graphSnapshotFacade, GlobalIdFactory globalIdFactory) {
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
        this.commitFactory = commitFactory;
        this.repository = repository;
        this.graphSnapshotFacade = graphSnapshotFacade;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public Commit commit(String author, Object currentVersion) {
        Commit commit = this.commitFactory.create(author, currentVersion);
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Commit commitShallowDelete(String author, Object deleted) {
        Commit commit = this.commitFactory.createTerminal(author, deleted);
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId) {
        Commit commit = this.commitFactory.createTerminalByGlobalId(author, this.globalIdFactory.createFromDto(globalId));
        this.repository.persist(commit);
        logger.info(commit.toString());
        return commit;
    }

    @Override
    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.diffFactory.compare(oldVersion, currentVersion);
    }

    @Override
    public Diff initial(Object newDomainObject) {
        return this.diffFactory.initial(newDomainObject);
    }

    @Override
    public String toJson(Diff diff) {
        return this.jsonConverter.toJson(diff);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalIdDTO globalId, int limit) {
        return this.repository.getStateHistory(globalId, limit);
    }

    @Override
    public Optional<CdoSnapshot> getLatestSnapshot(GlobalIdDTO globalId) {
        return this.repository.getLatest(globalId);
    }

    @Override
    public List<Change> getChangeHistory(GlobalIdDTO globalId, int limit) {
        return this.graphSnapshotFacade.getChangeHistory(globalId, limit);
    }

    @Override
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Override
    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        ChangeListTraverser.traverse(changes, changeProcessor);
        return changeProcessor.result();
    }

    @Override
    public IdBuilder idBuilder() {
        return new IdBuilder(this.globalIdFactory);
    }

    JaversType getForClass(Class<?> clazz) {
        return this.typeMapper.getJaversType(clazz);
    }
}

