/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Objects;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ElementValueChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;

class StepsToChanges {
    StepsToChanges() {
    }

    List<ContainerElementChange> convert(BacktrackSteps[][] backtrack, List leftList, List rightList) {
        int i = leftList.size();
        int j = rightList.size();
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        while (i * j != 0) {
            BacktrackSteps choice = backtrack[i][j];
            Object leftValue = leftList.get(i - 1);
            Object rightValue = rightList.get(j - 1);
            if (choice == BacktrackSteps.TAKE) {
                if (!Objects.nullSafeEquals(leftValue, rightValue)) {
                    changes.add(new ElementValueChange(i - 1, leftValue, rightValue));
                }
                --i;
                --j;
                continue;
            }
            if (choice == BacktrackSteps.SKIP_LEFT) {
                changes.add(new ValueRemoved(i - 1, leftValue));
                --i;
                continue;
            }
            if (choice != BacktrackSteps.SKIP_RIGHT) continue;
            changes.add(new ValueAdded(j - 1, rightValue));
            --j;
        }
        while (i > 0) {
            changes.add(new ValueRemoved(i - 1, leftList.get(i - 1)));
            --i;
        }
        while (j > 0) {
            changes.add(new ValueAdded(j - 1, rightList.get(j - 1)));
            --j;
        }
        return changes;
    }
}

