/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.cases;

import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.annotation.Entity;
import org.javers.core.metamodel.annotation.Id;
import org.javers.core.metamodel.object.ValueObjectId;
import org.junit.Assert;
import org.junit.Test;

public class NpeFromReflectionUtilCase {
    @Test
    public void shouldSupportInterfaceProperty() {
        TestClassWithInterfaceProperty foo = new TestClassWithInterfaceProperty("1", new TestInterfaceImpl("Foo"));
        TestClassWithInterfaceProperty bar = new TestClassWithInterfaceProperty("1", new TestInterfaceImpl("Bar"));
        Javers javers = JaversBuilder.javers().build();
        Diff diff = javers.compare((Object)foo, (Object)bar);
        System.out.println(diff);
        Assert.assertTrue((diff.getChanges().size() == 1 ? 1 : 0) != 0);
        ValueChange change = (ValueChange)diff.getChangesByType(ValueChange.class).get(0);
        ValueObjectId voId = javers.idBuilder().withOwner((Object)"1", TestClassWithInterfaceProperty.class).voId(TestInterface.class, "interfaceProperty");
        Assertions.assertThat((Object)change.getAffectedGlobalId()).isEqualTo((Object)voId);
        Assertions.assertThat((String)change.getProperty().getName()).isEqualTo((Object)"value");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)"Foo");
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)"Bar");
    }

    class TestInterfaceImpl
    implements TestInterface {
        private String value;

        public TestInterfaceImpl(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return "Foo";
        }
    }

    static interface TestInterface {
        public String getValue();
    }

    @Entity
    class TestClassWithInterfaceProperty {
        @Id
        private String id;
        private TestInterface interfaceProperty;

        public TestClassWithInterfaceProperty(String id, TestInterfaceImpl interfaceProperty) {
            this.id = id;
            this.interfaceProperty = interfaceProperty;
        }
    }
}

