/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples.listalgorithm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.examples.listalgorithm.A;
import org.javers.core.examples.listalgorithm.B;
import org.junit.Assert;
import org.junit.Test;

public class BehaviorDifference {
    @Test
    public void compareMethods() {
        A a1 = new A(1);
        A a2 = new A(1);
        B b1 = new B(2);
        B b2 = new B(2);
        a1.setAnyList(BehaviorDifference.asList(b1));
        a2.setAnyList(BehaviorDifference.asList(b2));
        Javers javers = JaversBuilder.javers().build();
        Diff diff1 = javers.compare((Object)a1, (Object)a2);
        this.checkNoDiff(diff1);
        javers = JaversBuilder.javers().withListCompareAlgorithm(ListCompareAlgorithm.LEVENSHTEIN_DISTANCE).build();
        Diff diff2 = javers.compare((Object)a1, (Object)a2);
        this.checkNoDiff(diff2);
    }

    public void checkNoDiff(Diff diff) {
        Assert.assertTrue((String)("No changes should have been detected !\n" + diff.changesSummary()), (!diff.hasChanges() ? 1 : 0) != 0);
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... objects) {
        ArrayList list = Lists.newArrayList();
        for (T t : objects) {
            list.add(t);
        }
        return list;
    }
}

