/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples.listalgorithm;

import java.util.ArrayList;
import java.util.List;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.examples.listalgorithm.CodeLabel;
import org.javers.core.examples.listalgorithm.ListContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestListChanges {
    List<CodeLabel> bs1 = new ArrayList<CodeLabel>();
    List<CodeLabel> bs2 = new ArrayList<CodeLabel>();
    Javers javers = JaversBuilder.javers().withListCompareAlgorithm(ListCompareAlgorithm.LEVENSHTEIN_DISTANCE).build();

    @Before
    public void setup() {
        this.bs1.clear();
        this.bs2.clear();
        this.bs1.add(new CodeLabel("ID1", "Value1"));
        this.bs1.add(new CodeLabel("ID2", "Value2"));
        this.bs1.add(new CodeLabel("ID3", "Value3"));
        this.bs2.add(new CodeLabel("ID1", "Value1"));
        this.bs2.add(new CodeLabel("ID2", "Value3"));
    }

    @Test
    public void bothComparison() {
        Diff diffDirect = this.javers.compare(this.bs1, this.bs2);
        ListContainer obj1 = new ListContainer(this.bs1);
        ListContainer obj2 = new ListContainer(this.bs2);
        Diff diffWithContainer = this.javers.compare((Object)obj1, (Object)obj2);
        System.out.println("diffDirect: " + diffDirect);
        System.out.println("diffWithContainer: " + diffWithContainer);
        Assert.assertSame((Object)this.nbRemoved(diffDirect), (Object)this.nbRemoved(diffWithContainer));
        Assert.assertSame((Object)this.nbAdded(diffDirect), (Object)this.nbAdded(diffWithContainer));
        Assert.assertSame((Object)this.count(diffDirect), (Object)this.count(diffWithContainer));
    }

    private void displayInfo(Diff diff) {
        System.out.println(diff.changesSummary());
        for (Change ch : diff.getChanges()) {
            System.out.println(ch);
        }
        System.out.println(this.nbRemoved(diff) + " objects removed /" + this.nbAdded(diff) + " objects added");
    }

    private int count(Diff diff) {
        int cnt = 0;
        for (Change ch : diff.getChanges()) {
            if (ch instanceof ListChange) {
                cnt += ((ListChange)ch).getChanges().size();
                continue;
            }
            ++cnt;
        }
        return cnt;
    }

    private int nbRemoved(Diff diff) {
        return diff.getChangesByType(ObjectRemoved.class).size();
    }

    private int nbAdded(Diff diff) {
        return diff.getChangesByType(NewObject.class).size();
    }
}

