/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.javers.common.exception.JaversGetterException;
import org.javers.common.reflection.JaversMember;

public class JaversField
extends JaversMember<Field> {
    public JaversField(Field rawField, Type resolvedReturnType) {
        super(rawField, resolvedReturnType);
    }

    @Override
    protected Type getRawGenericType() {
        return ((Field)this.getRawMember()).getGenericType();
    }

    @Override
    public Class<?> getType() {
        return ((Field)this.getRawMember()).getType();
    }

    @Override
    public Object invokeEvenIfPrivate(Object onObject) {
        this.setAccessibleIfNecessary();
        try {
            return ((Field)this.getRawMember()).get(onObject);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JaversGetterException("error getting value from the field {" + this + "}, " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "Field " + this.getGenericType() + " " + this.name() + "; //declaring class:" + this.getDeclaringClass().getName();
    }
}

