/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Predicate;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsDomainClass;
import org.javers.core.metamodel.property.Property;

public abstract class ManagedClass
extends ClientsDomainClass {
    private final Map<String, Property> propertiesByName;
    private final List<Property> properties;

    ManagedClass(Class clientsClass, List<Property> properties) {
        super(clientsClass);
        Validate.argumentsAreNotNull(properties);
        this.properties = new ArrayList<Property>(properties);
        this.propertiesByName = new HashMap<String, Property>();
        for (Property property : properties) {
            this.propertiesByName.put(property.getName(), property);
        }
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<Property> getProperties(Predicate<Property> query) {
        ArrayList<Property> retProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!query.apply(property)) continue;
            retProperties.add(property);
        }
        return retProperties;
    }

    public Property getProperty(String withName) {
        Validate.argumentIsNotNull(withName);
        if (!this.propertiesByName.containsKey(withName)) {
            throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, withName, this.getName());
        }
        return this.propertiesByName.get(withName);
    }

    public boolean hasProperty(String withName) {
        try {
            this.getProperty(withName);
            return true;
        }
        catch (JaversException e) {
            return false;
        }
    }
}

