/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.api.JaversRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    private Map<GlobalId, LinkedList<CdoSnapshot>> snapshots = new ConcurrentHashMap<GlobalId, LinkedList<CdoSnapshot>>();
    private CommitId head;

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(final Entity ownerEntity, final String path, int limit) {
        Validate.argumentsAreNotNull(ownerEntity, path);
        List<CdoSnapshot> result = Lists.positiveFilter(this.getAll(), new Predicate<CdoSnapshot>(){

            @Override
            public boolean apply(CdoSnapshot input) {
                if (!(input.getGlobalId() instanceof ValueObjectId)) {
                    return false;
                }
                ValueObjectId id = (ValueObjectId)input.getGlobalId();
                return id.getOwnerId().getCdoClass().getClientsClass().equals(ownerEntity.getClientsClass()) && id.getFragment().equals(path);
            }
        });
        return this.limit(result, limit);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, int limit) {
        Validate.argumentIsNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            return Collections.unmodifiableList(this.limit((List<CdoSnapshot>)this.snapshots.get(globalId), limit));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<CdoSnapshot> getStateHistory(ManagedClass givenClass, int limit) {
        Validate.argumentIsNotNull(givenClass);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            if (!snapshot.getGlobalId().getCdoClass().getClientsClass().equals(givenClass.getClientsClass())) continue;
            filtered.add(snapshot);
        }
        return this.limit(filtered, limit);
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(GlobalId globalId, String propertyName, int limit) {
        Validate.argumentsAreNotNull(globalId, propertyName);
        if (this.snapshots.containsKey(globalId)) {
            List<CdoSnapshot> filtered = this.filterByPropertyName((List<CdoSnapshot>)this.snapshots.get(globalId), propertyName);
            return Collections.unmodifiableList(this.limit(filtered, limit));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(ManagedClass givenClass, String propertyName, int limit) {
        Validate.argumentsAreNotNull(givenClass, propertyName);
        List<CdoSnapshot> filtered = this.filterByPropertyName(this.getStateHistory(givenClass, limit * 10), propertyName);
        return Collections.unmodifiableList(this.limit(filtered, limit));
    }

    private List<CdoSnapshot> limit(List<CdoSnapshot> list, int limit) {
        int size = list.size();
        if (size <= limit) {
            return list;
        }
        return list.subList(0, limit);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentsAreNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            LinkedList<CdoSnapshot> states = this.snapshots.get(globalId);
            return Optional.of(states.peek());
        }
        return Optional.empty();
    }

    @Override
    public void persist(Commit commit) {
        Validate.argumentsAreNotNull(commit);
        List<CdoSnapshot> snapshots = commit.getSnapshots();
        for (CdoSnapshot s : snapshots) {
            this.persist(s);
        }
        logger.debug("{} snapshot(s) persisted", (Object)snapshots.size());
        this.head = commit.getId();
    }

    @Override
    public CommitId getHeadId() {
        return this.head;
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    private List<CdoSnapshot> filterByPropertyName(List<CdoSnapshot> snapshots, final String propertyName) {
        return Lists.positiveFilter(snapshots, new Predicate<CdoSnapshot>(){

            @Override
            public boolean apply(CdoSnapshot input) {
                return input.hasChangeAt(propertyName);
            }
        });
    }

    private List<CdoSnapshot> getAll() {
        ArrayList<CdoSnapshot> all = new ArrayList<CdoSnapshot>();
        for (LinkedList<CdoSnapshot> snapshotsList : this.snapshots.values()) {
            all.addAll(snapshotsList);
        }
        Collections.sort(all, new Comparator<CdoSnapshot>(){

            @Override
            public int compare(CdoSnapshot o1, CdoSnapshot o2) {
                return o2.getCommitId().compareTo(o1.getCommitId());
            }
        });
        return all;
    }

    private synchronized void persist(CdoSnapshot snapshot) {
        LinkedList<CdoSnapshot> states = this.snapshots.get(snapshot.getGlobalId());
        if (states == null) {
            states = new LinkedList();
            this.snapshots.put(snapshot.getGlobalId(), states);
        }
        states.push(snapshot);
    }

    @Override
    public void ensureSchema() {
    }
}

