/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;

public class MapChange
extends PropertyChange {
    private final List<EntryChange> changes;

    public MapChange(GlobalId affectedCdoId, Property property, List<EntryChange> changes) {
        super(affectedCdoId, property);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<EntryChange>(changes));
    }

    public List<EntryChange> getEntryChanges() {
        return this.changes;
    }

    @Override
    protected String fieldsToString() {
        StringBuilder changesAsString = new StringBuilder();
        for (EntryChange c : this.changes) {
            if (changesAsString.length() > 0) {
                changesAsString.append(", ");
            }
            changesAsString.append(c);
        }
        return super.fieldsToString() + ToStringBuilder.addEnumField("entryChanges", changesAsString);
    }
}

