/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapEnumeratorContext;

public class DehydrateMapFunction
implements EnumerableFunction {
    private final GlobalIdFactory globalIdFactory;
    private final MapContentType mapContentType;

    public DehydrateMapFunction(GlobalIdFactory globalIdFactory, MapContentType mapContentType) {
        Validate.argumentsAreNotNull(globalIdFactory, mapContentType);
        this.globalIdFactory = globalIdFactory;
        this.mapContentType = mapContentType;
    }

    public Object apply(Object input, OwnerContext enumerationAwareOwnerContext) {
        MapEnumeratorContext mapContext = (MapEnumeratorContext)enumerationAwareOwnerContext.getEnumeratorContext();
        if (mapContext.isKey()) {
            return this.globalIdFactory.dehydrate(input, this.mapContentType.getKeyType(), enumerationAwareOwnerContext);
        }
        return this.globalIdFactory.dehydrate(input, this.mapContentType.getValueType(), enumerationAwareOwnerContext);
    }
}

