/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Primitives;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.DehydratedTypeFactory;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.TypeMapperState;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private final TypeMapperState state;
    private final DehydratedTypeFactory dehydratedTypeFactory = new DehydratedTypeFactory(this);

    public TypeMapper(TypeFactory typeFactory) {
        this.state = new TypeMapperState(typeFactory);
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        this.registerValueType(LocalDateTime.class);
        this.registerValueType(LocalDate.class);
        this.registerValueType(BigDecimal.class);
        this.registerValueType(Date.class);
        this.registerValueType(ThreadLocal.class);
        this.registerValueType(URI.class);
        this.registerValueType(URL.class);
        this.registerValueType(Path.class);
        this.addType(new SetType((Type)((Object)Set.class)));
        this.addType(new ListType((Type)((Object)List.class)));
        this.addType(new MapType((Type)((Object)Map.class)));
        if (ReflectionUtil.isJava8runtime()) {
            this.addType(new OptionalType());
        }
    }

    public MapContentType getMapContentType(MapType mapType) {
        JaversType keyType = this.getJaversType(mapType.getKeyType());
        JaversType valueType = this.getJaversType(mapType.getValueType());
        return new MapContentType(keyType, valueType);
    }

    public MapContentType getMapContentType(ContainerType containerType) {
        JaversType keyType = this.getJaversType((Type)((Object)Integer.class));
        JaversType valueType = this.getJaversType(containerType.getItemType());
        return new MapContentType(keyType, valueType);
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        return this.state.getJaversType(javaType);
    }

    public ManagedType getJaversManagedType(Class javaType) {
        JaversType javersType = this.getJaversType(javaType);
        if (!(javersType instanceof ManagedType)) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, javaType.getName(), javersType.getClass().getSimpleName());
        }
        return (ManagedType)javersType;
    }

    public <T extends JaversType> T getPropertyType(Property property) {
        Validate.argumentIsNotNull(property);
        return (T)this.getJaversType(property.getGenericType());
    }

    private void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerClientsClass(ClientsClassDefinition def) {
        this.state.computeIfAbsent(def);
    }

    public void registerValueType(Class<?> valueCLass) {
        this.addType(new ValueType(valueCLass));
    }

    public void registerCustomType(Class<?> customCLass) {
        this.addType(new CustomType(customCLass));
    }

    public boolean isValueObject(Type type) {
        JaversType jType = this.getJaversType(type);
        return jType instanceof ValueObjectType;
    }

    public Type getDehydratedType(Type type) {
        return this.dehydratedTypeFactory.build(type);
    }

    public <T extends ManagedClass> T getManagedClass(Class javaClass, Class<T> expectedType) {
        ManagedType mType = this.getJaversManagedType(javaClass);
        if (mType.getManagedClass().getClass().equals(expectedType)) {
            return (T)mType.getManagedClass();
        }
        throw new JaversException(JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR, javaClass, mType.getManagedClass().getSimpleName(), expectedType.getSimpleName());
    }

    public ValueObject getChildValueObject(Entity owner, String voPropertyName) {
        JaversType contentType;
        JaversType javersType = this.getJaversType(owner.getProperty(voPropertyName).getGenericType());
        if (javersType instanceof ValueObjectType) {
            return ((ValueObjectType)javersType).getManagedClass();
        }
        if (javersType instanceof ContainerType && (contentType = this.getJaversType(((ContainerType)javersType).getItemType())) instanceof ValueObjectType) {
            return ((ValueObjectType)contentType).getManagedClass();
        }
        throw new JaversException(JaversExceptionCode.CANT_EXTRACT_CHILD_VALUE_OBJECT, owner.getName() + "." + voPropertyName, javersType);
    }

    private void addType(JaversType jType) {
        this.state.putIfAbsent(jType.getBaseJavaType(), jType);
    }
}

