/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.type.ValueObjectType;

public class ValueObjectId
extends UnboundedValueObjectId {
    private final GlobalId ownerId;
    private final String fragment;

    public ValueObjectId(ValueObjectType valueObject, GlobalId ownerId, String fragment) {
        super(valueObject);
        Validate.argumentsAreNotNull(ownerId, fragment);
        this.ownerId = ownerId;
        this.fragment = fragment;
    }

    public ValueObjectId(ValueObjectType valueObject, OwnerContext ownerContext) {
        this(valueObject, ownerContext.getGlobalId(), ownerContext.getPath());
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    public GlobalId getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String value() {
        return this.getOwnerId().value() + "#" + this.fragment;
    }
}

