/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.Entity;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ManagedType;

public class EntityType
extends ManagedType {
    public EntityType(Entity entity) {
        super(entity);
    }

    @Override
    @Deprecated
    public Entity getManagedClass() {
        return (Entity)super.getManagedClass();
    }

    @Override
    ManagedType spawn(Class javaType, ManagedClassFactory managedClassFactory) {
        return new EntityType(managedClassFactory.create(new EntityDefinition(javaType, this.getManagedClass().getIdProperty())));
    }

    public Type getIdPropertyGenericType() {
        return this.getManagedClass().getIdProperty().getGenericType();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.getBaseJavaType(), "id", this.getIdProperty().getName());
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addField("idProperty", this.getIdProperty().getName());
    }

    public Property getIdProperty() {
        return this.getManagedClass().getIdProperty();
    }

    public Object getIdOf(Object instance) {
        Validate.argumentIsNotNull(instance);
        if (!this.getBaseJavaClass().isInstance(instance)) {
            throw new JaversException(JaversExceptionCode.NOT_INSTANCE_OF, this.getName(), instance.getClass().getName());
        }
        Object cdoId = this.getIdProperty().get(instance);
        if (cdoId == null) {
            throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_ID, this.getName());
        }
        return cdoId;
    }
}

