/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.type.ClientsDomainClass;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.Entity;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.Value;
import org.javers.core.metamodel.type.ValueObject;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypeFactory.class);
    private final ManagedClassFactory managedClassFactory;

    TypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    JaversType create(ClientsClassDefinition def) {
        if (def instanceof CustomDefinition) {
            return new CustomType(def.getClazz());
        }
        return this.createFromClientsClass(this.managedClassFactory.create(def));
    }

    EntityType createEntity(Class<?> javaType) {
        return (EntityType)this.create(new EntityDefinition(javaType));
    }

    JaversType infer(Type javaType, Optional<JaversType> prototype) {
        JaversType jType;
        if (prototype.isPresent()) {
            jType = this.spawnFromPrototype(javaType, prototype.get());
            logger.info("javersType of [{}] inferred as {} from prototype {}", new Object[]{jType.getBaseJavaClass(), jType.getClass().getSimpleName(), prototype.get()});
        } else {
            jType = this.inferFromAnnotations(javaType);
            logger.info("javersType of [{}] inferred as {}", (Object)jType.getBaseJavaClass(), (Object)jType.getClass().getSimpleName());
        }
        return jType;
    }

    ValueType inferIdPropertyTypeAsValue(Type idPropertyGenericType) {
        logger.info("javersType of [{}] inferred as ValueType, it's used as id-property type", (Object)idPropertyGenericType);
        return new ValueType(idPropertyGenericType);
    }

    private JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            return ((ManagedType)prototype).spawn(javaClass, this.managedClassFactory);
        }
        return prototype.spawn(javaType);
    }

    private JaversType inferFromAnnotations(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        return this.createFromClientsClass(this.managedClassFactory.inferFromAnnotations(javaClass));
    }

    private JaversType createFromClientsClass(ClientsDomainClass clientsClass) {
        if (clientsClass instanceof Value) {
            return new ValueType((Value)clientsClass);
        }
        if (clientsClass instanceof ValueObject) {
            return new ValueObjectType((ValueObject)clientsClass);
        }
        if (clientsClass instanceof Entity) {
            return new EntityType((Entity)clientsClass);
        }
        throw new IllegalArgumentException("unsupported " + clientsClass.getName());
    }
}

