/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.common.collections.Function;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.type.DistancePair;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.ValueType;

class TypeMapperState {
    private final Map<Type, JaversType> mappedTypes = new ConcurrentHashMap<Type, JaversType>();
    private final TypeFactory typeFactory;
    private final ValueType OBJECT_TYPE = new ValueType((Type)((Object)Object.class));

    TypeMapperState(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        if (javaType == Object.class) {
            return this.OBJECT_TYPE;
        }
        JaversType jType = this.mappedTypes.get(javaType);
        if (jType != null) {
            return jType;
        }
        return this.computeIfAbsent(javaType, new Function<Type, JaversType>(){

            @Override
            public JaversType apply(Type type) {
                return TypeMapperState.this.infer(type);
            }
        });
    }

    void putIfAbsent(Type javaType, final JaversType jType) {
        this.computeIfAbsent(javaType, new Function<Type, JaversType>(){

            @Override
            public JaversType apply(Type ignored) {
                return jType;
            }
        });
    }

    void computeIfAbsent(final ClientsClassDefinition def) {
        this.computeIfAbsent(def.getClazz(), new Function<Type, JaversType>(){

            @Override
            public JaversType apply(Type ignored) {
                return TypeMapperState.this.typeFactory.create(def);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaversType computeIfAbsent(Type javaType, Function<Type, JaversType> computeFunction) {
        Type type = javaType;
        synchronized (type) {
            JaversType mappedType = this.mappedTypes.get(javaType);
            if (mappedType != null) {
                return mappedType;
            }
            JaversType newType = computeFunction.apply(javaType);
            this.mappedTypes.put(javaType, newType);
            this.inferIdPropertyTypeForEntityIfNeed(newType);
            return newType;
        }
    }

    private void inferIdPropertyTypeForEntityIfNeed(JaversType jType) {
        Validate.argumentIsNotNull(jType);
        if (jType instanceof EntityType) {
            EntityType entityType = (EntityType)jType;
            Type idType = entityType.getIdPropertyGenericType();
            this.mappedTypes.put(idType, this.typeFactory.inferIdPropertyTypeAsValue(idType));
        }
    }

    private JaversType infer(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType prototype = this.findNearestAncestor(javaType);
        JaversType newType = this.typeFactory.infer(javaType, Optional.fromNullable(prototype));
        return newType;
    }

    private JaversType findNearestAncestor(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ArrayList<DistancePair> distances = new ArrayList<DistancePair>();
        for (JaversType javersType : this.mappedTypes.values()) {
            DistancePair distancePair = new DistancePair(javaClass, javersType);
            if (javaClass.isArray()) {
                return this.getJaversType((Type)((Object)Object[].class));
            }
            if (distancePair.getDistance() == 1) {
                return distancePair.getJaversType();
            }
            distances.add(distancePair);
        }
        Collections.sort(distances);
        if (((DistancePair)distances.get(0)).isMax()) {
            return null;
        }
        return ((DistancePair)distances.get(0)).getJaversType();
    }
}

