/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Objects;
import org.javers.common.validation.Validate;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.TypeMapper;

public class LevenshteinListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    LevenshteinListChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        Validate.argumentsAreNotNull(typeMapper, globalIdFactory);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, Property property) {
        List leftList = Lists.wrapNull((List)pair.getLeftPropertyValue(property));
        List rightList = Lists.wrapNull((List)pair.getRightPropertyValue(property));
        EqualsFunction equalsFunction = this.createDehydratingEqualsFunction(pair, property);
        Backtrack backtrack = new Backtrack(equalsFunction);
        StepsToChanges stepsToChanges = new StepsToChanges(equalsFunction);
        BacktrackSteps[][] steps = backtrack.evaluateSteps(leftList, rightList);
        List<ContainerElementChange> changes = stepsToChanges.convert(steps, leftList, rightList);
        return this.getListChange(pair.getGlobalId(), property, changes);
    }

    private EqualsFunction createDehydratingEqualsFunction(NodePair pair, Property property) {
        ListType listType = (ListType)this.typeMapper.getPropertyType(property);
        final JaversType listContentType = this.typeMapper.getJaversType(listType.getItemType());
        final OwnerContext owner = new OwnerContext(pair.getGlobalId(), property.getName());
        return new EqualsFunction(){

            @Override
            public boolean nullSafeEquals(Object left, Object right) {
                Object leftDehydrated = LevenshteinListChangeAppender.this.globalIdFactory.dehydrate(left, listContentType, owner);
                Object rightDehydrated = LevenshteinListChangeAppender.this.globalIdFactory.dehydrate(right, listContentType, owner);
                return Objects.nullSafeEquals(leftDehydrated, rightDehydrated);
            }
        };
    }

    private ListChange getListChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        ListChange result = changes.size() == 0 ? null : new ListChange(affectedCdoId, property, changes);
        return result;
    }
}

