/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples;

import java.util.Collection;
import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.common.collections.Lists;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.examples.model.Person;
import org.junit.Test;

public class ComparingTopLevelCollectionExample {
    @Test
    public void shouldDeeplyCompareTwoTopLevelCollections() {
        Javers javers = JaversBuilder.javers().build();
        List oldList = Lists.asList((Object[])new Person[]{new Person("tommy", "Tommy Smart")});
        List newList = Lists.asList((Object[])new Person[]{new Person("tommy", "Tommy C. Smart")});
        Diff diff = javers.compareCollections((Collection)oldList, (Collection)newList, Person.class);
        ValueChange change = (ValueChange)diff.getChangesByType(ValueChange.class).get(0);
        Assertions.assertThat((List)diff.getChanges()).hasSize(1);
        Assertions.assertThat((String)change.getProperty().getName()).isEqualTo((Object)"name");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)"Tommy Smart");
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)"Tommy C. Smart");
        System.out.println(diff);
    }
}

