/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.annotation.ClassAnnotationsScan;
import org.javers.core.metamodel.annotation.ClassAnnotationsScanner;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypeFactory.class);
    private PropertyScanner propertyScanner;
    private ClassAnnotationsScanner classAnnotationsScanner;
    private final ManagedClassFactory managedClassFactory;

    public TypeFactory(ManagedClassFactory managedClassFactory, ClassAnnotationsScanner classAnnotationsScanner, PropertyScanner propertyScanner) {
        this.managedClassFactory = managedClassFactory;
        this.classAnnotationsScanner = classAnnotationsScanner;
        this.propertyScanner = propertyScanner;
    }

    JaversType create(ClientsClassDefinition def) {
        if (def instanceof CustomDefinition) {
            return new CustomType(def.getBaseJavaClass());
        }
        if (def instanceof EntityDefinition) {
            return this.createEntity((EntityDefinition)def);
        }
        if (def instanceof ValueObjectDefinition) {
            return this.createValueObject((ValueObjectDefinition)def);
        }
        if (def instanceof ValueDefinition) {
            return new ValueType(def.getBaseJavaClass());
        }
        throw new IllegalArgumentException("unsupported definition " + def.getClass().getSimpleName());
    }

    EntityType createEntity(Class<?> javaType) {
        return (EntityType)this.create(new EntityDefinition(javaType));
    }

    ValueObjectType createValueObject(ValueObjectDefinition definition) {
        ManagedClass managedClass = this.managedClassFactory.create(definition);
        return new ValueObjectType(managedClass, definition.getTypeName());
    }

    EntityType createEntity(EntityDefinition definition) {
        ManagedClass managedClass = this.managedClassFactory.create(definition);
        if (definition.hasCustomId()) {
            Property idProperty = managedClass.getProperty(definition.getIdPropertyName());
            return new EntityType(managedClass, Optional.of(idProperty), definition.getTypeName());
        }
        return new EntityType(managedClass, Optional.empty(), definition.getTypeName());
    }

    JaversType infer(Type javaType, Optional<JaversType> prototype) {
        JaversType jType;
        if (prototype.isPresent()) {
            jType = this.spawnFromPrototype(javaType, prototype.get());
            logger.info("javersType of {} inferred as {} from prototype {}", new Object[]{javaType, jType.getClass().getSimpleName(), prototype.get()});
        } else {
            jType = this.inferFromAnnotations(javaType);
            logger.info("javersType of {} inferred as {}", (Object)javaType, (Object)jType.getClass().getSimpleName());
        }
        return jType;
    }

    ValueType inferIdPropertyTypeAsValue(Type idPropertyGenericType) {
        logger.info("javersType of [{}] inferred as ValueType, it's used as id-property type", (Object)idPropertyGenericType);
        return new ValueType(idPropertyGenericType);
    }

    private JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            ManagedClass managedClass = this.managedClassFactory.create(javaClass);
            return ((ManagedType)prototype).spawn(managedClass);
        }
        return prototype.spawn(javaType);
    }

    JaversType inferFromAnnotations(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ClassAnnotationsScan scan = this.classAnnotationsScanner.scan(javaClass);
        if (scan.hasValue()) {
            return this.create(new ValueDefinition(javaClass));
        }
        ClientsClassDefinition.ClientsClassDefinitionBuilder builder = this.hasIdProperty(javaClass) || scan.hasEntity() ? EntityDefinition.EntityDefinitionBuilder.entityDefinition(javaClass) : ValueObjectDefinition.ValueObjectDefinitionBuilder.valueObjectDefinition(javaClass);
        if (scan.typeName().isPresent()) {
            builder.withTypeName(scan.typeName().get());
        }
        return this.create(builder.build());
    }

    private boolean hasIdProperty(Class<?> javaClass) {
        for (Property property : this.propertyScanner.scan(javaClass)) {
            if (!property.looksLikeId()) continue;
            return true;
        }
        return false;
    }
}

