/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Type;
import org.javers.common.reflection.JaversMember;
import org.javers.common.validation.Validate;

public class Property {
    public static final String ID_ANN = "Id";
    private final transient JaversMember member;
    private final transient boolean hasTransientAnn;

    Property(JaversMember member, boolean hasTransientAnn) {
        Validate.argumentIsNotNull(member);
        this.member = member;
        this.hasTransientAnn = hasTransientAnn;
    }

    public Type getGenericType() {
        return this.member.getGenericType();
    }

    public Class<?> getType() {
        return this.member.getType();
    }

    public boolean looksLikeId() {
        return this.member.isAnnotationPresent(ID_ANN);
    }

    public Object get(Object target) {
        return this.member.invokeEvenIfPrivate(target);
    }

    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    public String getName() {
        return this.member.propertyName();
    }

    public boolean isHasTransientAnn() {
        return this.hasTransientAnn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return this.member.equals(that.member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }
}

