/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.io.Serializable;
import org.javers.common.collections.Consumer;
import org.javers.common.validation.Validate;

public class Optional<T>
implements Serializable {
    private static Optional EMPTY = new Optional();
    private T reference;

    private Optional() {
    }

    private Optional(T reference) {
        Validate.argumentIsNotNull(reference);
        this.reference = reference;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T reference) {
        return new Optional<T>(reference);
    }

    public static <T> Optional<T> fromNullable(T nullOrReference) {
        if (nullOrReference == null) {
            return Optional.empty();
        }
        return Optional.of(nullOrReference);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public T get() {
        if (this.isEmpty()) {
            throw new IllegalStateException("can't get() from empty optional");
        }
        return this.reference;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.reference != null) {
            consumer.consume(this.reference);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Optional other = (Optional)o;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isPresent() && other.isPresent()) {
            return this.reference.equals(other.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.reference != null ? this.reference.hashCode() : 0;
    }
}

