/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Objects;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;

class ValueChangeAppender
extends CorePropertyChangeAppender<ValueChange> {
    ValueChangeAppender() {
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof PrimitiveOrValueType;
    }

    @Override
    public ValueChange calculateChanges(NodePair pair, Property property) {
        Object leftValue = pair.getLeftPropertyValue(property);
        Object rightValue = pair.getRightPropertyValue(property);
        if (this.isIdProperty(pair, property) ? Objects.equals(ReflectionUtil.reflectiveToString(leftValue), ReflectionUtil.reflectiveToString(rightValue)) : Objects.equals(leftValue, rightValue)) {
            return null;
        }
        return new ValueChange(pair.getGlobalId(), property.getName(), leftValue, rightValue);
    }

    private boolean isIdProperty(NodePair nodePair, Property property) {
        ManagedType managedType = nodePair.getManagedType();
        if (managedType instanceof EntityType) {
            return ((EntityType)managedType).getIdProperty().equals(property);
        }
        return false;
    }
}

