/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.repository.api.QueryParams;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.PropertyFilter;
import org.javers.repository.jql.VoOwnerFilter;

public class JqlQuery {
    private final QueryParams queryParams;
    private final boolean newObjectChanges;
    private final List<Filter> filters;

    JqlQuery(List<Filter> filters, boolean newObjectChanges, QueryParams queryParams) {
        Validate.argumentsAreNotNull(filters);
        this.queryParams = queryParams;
        this.filters = filters;
        this.newObjectChanges = newObjectChanges;
    }

    public String toString() {
        return "JqlQuery{queryParams=" + this.queryParams + ", filters=" + this.filters + ", newObjectChanges=" + this.newObjectChanges + '}';
    }

    QueryParams getQueryParams() {
        return this.queryParams;
    }

    boolean hasFilter(Class<? extends Filter> ofType) {
        return this.getFilter(ofType).isPresent();
    }

    Class getClassFilter() {
        return this.getFilter(ClassFilter.class).get().getRequiredClass();
    }

    GlobalIdDTO getIdFilter() {
        return this.getFilter(IdFilter.class).get().getGlobalId();
    }

    String getPropertyName() {
        return this.getFilter(PropertyFilter.class).get().getPropertyName();
    }

    VoOwnerFilter getVoOwnerFilter() {
        return this.getFilter(VoOwnerFilter.class).get();
    }

    <T extends Filter> Optional<T> getFilter(Class<T> ofType) {
        for (Filter f : this.filters) {
            if (!f.getClass().equals(ofType)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    public boolean isNewObjectChanges() {
        return this.newObjectChanges;
    }

    boolean isIdOnlyQuery() {
        return this.hasFilter(IdFilter.class) && this.filters.size() == 1;
    }

    boolean isIdAndPropertyQuery() {
        return this.hasFilter(IdFilter.class) && this.hasFilter(PropertyFilter.class);
    }

    boolean isClassOnlyQuery() {
        return this.hasFilter(ClassFilter.class) && this.filters.size() == 1;
    }

    boolean isClassAndPropertyQuery() {
        return this.hasFilter(ClassFilter.class) && this.hasFilter(PropertyFilter.class);
    }

    boolean isVoOwnerOnlyQuery() {
        return this.hasFilter(VoOwnerFilter.class) && this.filters.size() == 1;
    }
}

