/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ManagedType;

public class CdoWrapper
extends Cdo {
    private final Object wrappedCdo;

    public CdoWrapper(Object wrappedCdo, GlobalId globalId, ManagedType managedType) {
        super(globalId, managedType);
        Validate.argumentsAreNotNull(wrappedCdo, managedType);
        Validate.argumentCheck(managedType.isInstance(wrappedCdo), "wrappedCdo is not an instance of given managedClass");
        this.wrappedCdo = wrappedCdo;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        Property property = this.getManagedType().getProperty(propertyName);
        return property.get(this.wrappedCdo);
    }

    @Override
    public Object getPropertyValue(Property property) {
        return property.get(this.wrappedCdo);
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.of(this.wrappedCdo);
    }

    @Override
    public boolean isNull(Property property) {
        return property.isNull(this.wrappedCdo);
    }
}

