/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

class PropertyScan {
    private final List<Property> properties;
    private final List<Property> looksLikeId;

    PropertyScan(List<Property> properties) {
        Validate.argumentIsNotNull(properties);
        this.properties = properties;
        this.looksLikeId = new ArrayList<Property>();
        for (Property p : properties) {
            if (!p.looksLikeId()) continue;
            this.looksLikeId.add(p);
        }
    }

    public Property getFirst() {
        return this.properties.get(0);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<Property> getLooksLikeId() {
        return Collections.unmodifiableList(this.looksLikeId);
    }

    public boolean hasId() {
        return !this.looksLikeId.isEmpty();
    }
}

