/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.ClientsClassDefinitionBuilder;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.EntityDefinitionBuilder;
import org.javers.core.metamodel.clazz.IgnoredTypeDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinitionBuilder;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScan;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.IgnoredType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypeFactory.class);
    private final ClassScanner classScanner;
    private final ManagedClassFactory managedClassFactory;

    public TypeFactory(ClassScanner classScanner, TypeMapper typeMapper) {
        this.classScanner = classScanner;
        this.managedClassFactory = new ManagedClassFactory(classScanner, typeMapper);
    }

    JaversType create(ClientsClassDefinition def) {
        if (def instanceof CustomDefinition) {
            return new CustomType(def.getBaseJavaClass());
        }
        if (def instanceof EntityDefinition) {
            return this.createEntity((EntityDefinition)def);
        }
        if (def instanceof ValueObjectDefinition) {
            return this.createValueObject((ValueObjectDefinition)def);
        }
        if (def instanceof ValueDefinition) {
            return new ValueType(def.getBaseJavaClass());
        }
        if (def instanceof IgnoredTypeDefinition) {
            return new IgnoredType(def.getBaseJavaClass());
        }
        throw new IllegalArgumentException("unsupported definition " + def.getClass().getSimpleName());
    }

    EntityType createEntity(Class<?> javaType) {
        return this.createEntity(new EntityDefinition(javaType));
    }

    private ValueObjectType createValueObject(ValueObjectDefinition definition) {
        return new ValueObjectType(this.managedClassFactory.create(definition), definition.getTypeName());
    }

    private EntityType createEntity(EntityDefinition definition) {
        ManagedClass managedClass = definition.isShallowReference() ? this.managedClassFactory.createShallowReferenceManagedClass(definition) : this.managedClassFactory.create(definition);
        if (definition.hasCustomId()) {
            Property idProperty = managedClass.getProperty(definition.getIdPropertyName());
            return new EntityType(managedClass, Optional.of(idProperty), definition.getTypeName());
        }
        return new EntityType(managedClass, Optional.empty(), definition.getTypeName());
    }

    JaversType infer(Type javaType, Optional<JaversType> prototype) {
        JaversType jType;
        if (prototype.isPresent()) {
            jType = this.spawnFromPrototype(javaType, prototype.get());
            logger.debug("javersType of {} inferred as {} from prototype {}", new Object[]{javaType, jType.getClass().getSimpleName(), prototype.get()});
        } else {
            jType = this.inferFromAnnotations(javaType);
            logger.debug("javersType of {} inferred as {}", (Object)javaType, (Object)jType.getClass().getSimpleName());
        }
        return jType;
    }

    ValueType inferIdPropertyTypeAsValue(Type idPropertyGenericType) {
        logger.debug("javersType of [{}] inferred as ValueType, it's used as id-property type", (Object)idPropertyGenericType);
        return new ValueType(idPropertyGenericType);
    }

    private JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            ManagedClass managedClass = this.managedClassFactory.create(javaClass);
            ClassScan scan = this.classScanner.scan(javaClass);
            return ((ManagedType)prototype).spawn(managedClass, scan.typeName());
        }
        return prototype.spawn(javaType);
    }

    JaversType inferFromAnnotations(Type javaType) {
        ClientsClassDefinitionBuilder builder;
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ClassScan scan = this.classScanner.scan(javaClass);
        if (scan.hasValueAnn()) {
            return this.create(new ValueDefinition(javaClass));
        }
        if (scan.hasIgnoredAnn()) {
            return this.create(new IgnoredTypeDefinition(javaClass));
        }
        if (scan.hasIdProperty() || scan.hasEntityAnn()) {
            builder = EntityDefinitionBuilder.entityDefinition(javaClass);
            if (scan.hasShallowReferenceAnn()) {
                ((EntityDefinitionBuilder)builder).withShallowReference();
            }
        } else {
            builder = ValueObjectDefinitionBuilder.valueObjectDefinition(javaClass);
        }
        if (scan.typeName().isPresent()) {
            builder.withTypeName(scan.typeName().get());
        }
        return this.create(builder.build());
    }
}

