/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.properties;

import org.javers.common.properties.PropertyConfiguration;

public abstract class AbstractConfiguration {
    private PropertyConfiguration propertyConfiguration;

    public AbstractConfiguration(PropertyConfiguration propertyConfiguration) {
        this.propertyConfiguration = propertyConfiguration;
    }

    public void readProperties(String classpathName) {
        this.propertyConfiguration = new PropertyConfiguration(classpathName);
        this.assemble();
    }

    protected <T extends Enum<T>> T getEnumProperty(String propertyKey, Class<T> enumType) {
        if (!this.containsPropertyKey(propertyKey)) {
            return null;
        }
        return this.propertyConfiguration.getEnumProperty(propertyKey, enumType);
    }

    protected String getStringProperty(String propertyKey) {
        return this.propertyConfiguration.getStringProperty(propertyKey);
    }

    protected boolean getBooleanProperty(String propertyKey) {
        if (!this.containsPropertyKey(propertyKey)) {
            return false;
        }
        return this.propertyConfiguration.getBooleanProperty(propertyKey);
    }

    public boolean containsPropertyKey(String propertyKey) {
        return this.propertyConfiguration.contains(propertyKey);
    }

    protected abstract void assemble();
}

