/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    private Map<GlobalId, LinkedList<CdoSnapshot>> snapshots = new ConcurrentHashMap<GlobalId, LinkedList<CdoSnapshot>>();
    private CommitId head;

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(final EntityType ownerEntity, final String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path);
        List<CdoSnapshot> result = Lists.positiveFilter(this.getAll(), new Predicate<CdoSnapshot>(){

            @Override
            public boolean apply(CdoSnapshot input) {
                if (!(input.getGlobalId() instanceof ValueObjectId)) {
                    return false;
                }
                ValueObjectId id = (ValueObjectId)input.getGlobalId();
                return id.hasOwnerOfType(ownerEntity) && id.getFragment().equals(path);
            }
        });
        return this.applyQueryParams(result, queryParams);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentIsNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            return Collections.unmodifiableList(this.applyQueryParams((List<CdoSnapshot>)this.snapshots.get(globalId), queryParams));
        }
        return Collections.emptyList();
    }

    @Override
    public List<CdoSnapshot> getStateHistory(ManagedType givenClass, QueryParams queryParams) {
        Validate.argumentIsNotNull(givenClass);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            if (!snapshot.getGlobalId().isTypeOf(givenClass)) continue;
            filtered.add(snapshot);
        }
        return this.applyQueryParams(filtered, queryParams);
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(GlobalId globalId, String propertyName, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, propertyName);
        if (this.snapshots.containsKey(globalId)) {
            List<CdoSnapshot> filtered = this.filterByPropertyName((List<CdoSnapshot>)this.snapshots.get(globalId), propertyName);
            return Collections.unmodifiableList(this.applyQueryParams(filtered, queryParams));
        }
        return Collections.emptyList();
    }

    @Override
    public List<CdoSnapshot> getPropertyStateHistory(ManagedType givenClass, String propertyName, QueryParams queryParams) {
        Validate.argumentsAreNotNull(givenClass, propertyName);
        QueryParams increasedLimitQueryParams = this.getQueryParamsWithIncreasedLimit(queryParams);
        List<CdoSnapshot> filtered = this.filterByPropertyName(this.getStateHistory(givenClass, increasedLimitQueryParams), propertyName);
        return Collections.unmodifiableList(this.applyQueryParams(filtered, queryParams));
    }

    private QueryParams getQueryParamsWithIncreasedLimit(QueryParams queryParams) {
        return QueryParamsBuilder.initializeWith(queryParams).limit(queryParams.limit() * 10).build();
    }

    private List<CdoSnapshot> applyQueryParams(List<CdoSnapshot> snapshots, final QueryParams queryParams) {
        if (queryParams.hasDates()) {
            snapshots = Lists.positiveFilter(snapshots, new Predicate<CdoSnapshot>(){

                @Override
                public boolean apply(CdoSnapshot snapshot) {
                    return queryParams.isDateInRange(snapshot.getCommitMetadata().getCommitDate());
                }
            });
        }
        return this.trimResultsToRequestedSize(snapshots, queryParams.limit());
    }

    private List<CdoSnapshot> trimResultsToRequestedSize(List<CdoSnapshot> snapshots, int requestedSize) {
        int size = snapshots.size();
        return size <= requestedSize ? snapshots : snapshots.subList(0, requestedSize);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentsAreNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            LinkedList<CdoSnapshot> states = this.snapshots.get(globalId);
            return Optional.of(states.peek());
        }
        return Optional.empty();
    }

    @Override
    public void persist(Commit commit) {
        Validate.argumentsAreNotNull(commit);
        List<CdoSnapshot> snapshots = commit.getSnapshots();
        for (CdoSnapshot s : snapshots) {
            this.persist(s);
        }
        logger.debug("{} snapshot(s) persisted", (Object)snapshots.size());
        this.head = commit.getId();
    }

    @Override
    public CommitId getHeadId() {
        return this.head;
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    private List<CdoSnapshot> filterByPropertyName(List<CdoSnapshot> snapshots, final String propertyName) {
        return Lists.positiveFilter(snapshots, new Predicate<CdoSnapshot>(){

            @Override
            public boolean apply(CdoSnapshot input) {
                return input.hasChangeAt(propertyName);
            }
        });
    }

    private List<CdoSnapshot> getAll() {
        ArrayList<CdoSnapshot> all = new ArrayList<CdoSnapshot>();
        for (LinkedList<CdoSnapshot> snapshotsList : this.snapshots.values()) {
            all.addAll(snapshotsList);
        }
        Collections.sort(all, new Comparator<CdoSnapshot>(){

            @Override
            public int compare(CdoSnapshot o1, CdoSnapshot o2) {
                return o2.getCommitId().compareTo(o1.getCommitId());
            }
        });
        return all;
    }

    private synchronized void persist(CdoSnapshot snapshot) {
        LinkedList<CdoSnapshot> states = this.snapshots.get(snapshot.getGlobalId());
        if (states == null) {
            states = new LinkedList();
            this.snapshots.put(snapshot.getGlobalId(), states);
        }
        states.push(snapshot);
    }

    @Override
    public void ensureSchema() {
    }
}

