/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import org.javers.common.collections.Optional;
import org.javers.core.commit.CommitId;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class QueryParams {
    private final int limit;
    private final int skip;
    private final Optional<LocalDateTime> from;
    private final Optional<LocalDateTime> to;
    private final Optional<CommitId> commitId;

    QueryParams(int limit, int skip, LocalDateTime from, LocalDateTime to, CommitId commitId) {
        this.limit = limit;
        this.skip = skip;
        this.from = Optional.fromNullable(from);
        this.to = Optional.fromNullable(to);
        this.commitId = Optional.fromNullable(commitId);
    }

    public int limit() {
        return this.limit;
    }

    public int skip() {
        return this.skip;
    }

    public boolean hasDates() {
        return this.from.isPresent() || this.to.isPresent();
    }

    public boolean isDateInRange(LocalDateTime date) {
        if (this.from.isPresent() && this.from.get().isAfter((ReadablePartial)date)) {
            return false;
        }
        return !this.to.isPresent() || !this.to.get().isBefore((ReadablePartial)date);
    }

    public Optional<LocalDateTime> from() {
        return this.from;
    }

    public Optional<LocalDateTime> to() {
        return this.to;
    }

    public Optional<CommitId> commitId() {
        return this.commitId;
    }

    public String toString() {
        return "QueryParams{limit=" + this.limit + ", skip=" + this.skip + ", from=" + this.from + ", to=" + this.to + ", commitId=" + this.commitId + "}";
    }
}

