/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.type.JaversType;

class DistancePair
implements Comparable<DistancePair> {
    private final Integer distance;
    private final JaversType javersType;

    DistancePair(Class javaClass, JaversType javersType) {
        this.javersType = javersType;
        this.distance = ReflectionUtil.calculateHierarchyDistance(javaClass, javersType.getBaseJavaClass());
    }

    @Override
    public int compareTo(DistancePair other) {
        return this.distance.compareTo(other.distance);
    }

    Integer getDistance() {
        return this.distance;
    }

    boolean isMax() {
        return this.distance == Integer.MAX_VALUE;
    }

    JaversType getJaversType() {
        return this.javersType;
    }
}

