/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples;

import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.examples.model.Employee;
import org.junit.Test;

public class EmployeeHierarchiesDiffExample {
    @Test
    public void shouldDetectSalaryChange() {
        Javers javers = JaversBuilder.javers().build();
        Employee oldBoss = new Employee("Big Boss").addSubordinates(new Employee("Noisy Manager"), new Employee("Great Developer", 10000));
        Employee newBoss = new Employee("Big Boss").addSubordinates(new Employee("Noisy Manager"), new Employee("Great Developer", 20000));
        Diff diff = javers.compare((Object)oldBoss, (Object)newBoss);
        ValueChange change = (ValueChange)diff.getChangesByType(ValueChange.class).get(0);
        Assertions.assertThat((Object)change.getAffectedLocalId()).isEqualTo((Object)"Great Developer");
        Assertions.assertThat((String)change.getPropertyName()).isEqualTo((Object)"salary");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)10000);
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)20000);
        System.out.println(diff);
    }

    @Test
    public void shouldDetectHired() {
        Javers javers = JaversBuilder.javers().build();
        Employee oldBoss = new Employee("Big Boss").addSubordinates(new Employee("Great Developer"));
        Employee newBoss = new Employee("Big Boss").addSubordinates(new Employee("Great Developer"), new Employee("Hired One"), new Employee("Hired Second"));
        Diff diff = javers.compare((Object)oldBoss, (Object)newBoss);
        Assertions.assertThat((List)diff.getObjectsByChangeType(NewObject.class)).hasSize(2).containsOnly(new Object[]{new Employee("Hired One"), new Employee("Hired Second")});
        System.out.println(diff);
    }

    @Test
    public void shouldDetectBossChange() {
        Javers javers = JaversBuilder.javers().build();
        Employee oldBoss = new Employee("Big Boss").addSubordinates(new Employee("Manager One").addSubordinate(new Employee("Great Developer")), new Employee("Manager Second"));
        Employee newBoss = new Employee("Big Boss").addSubordinates(new Employee("Manager One"), new Employee("Manager Second").addSubordinate(new Employee("Great Developer")));
        Diff diff = javers.compare((Object)oldBoss, (Object)newBoss);
        ReferenceChange change = (ReferenceChange)diff.getChangesByType(ReferenceChange.class).get(0);
        Assertions.assertThat((Object)change.getAffectedLocalId()).isEqualTo((Object)"Great Developer");
        Assertions.assertThat((String)change.getLeft().value()).endsWith("Manager One");
        Assertions.assertThat((String)change.getRight().value()).endsWith("Manager Second");
        System.out.println(diff);
    }

    @Test
    public void shouldDetectFiredInLargeDepthStructure() {
        Employee oldBoss;
        Javers javers = JaversBuilder.javers().build();
        Employee boss = oldBoss = new Employee("Big Boss");
        for (int i = 0; i < 1000; ++i) {
            boss.addSubordinate(new Employee("Emp no." + i));
            boss = boss.getSubordinates().get(0);
        }
        Employee newBoss = new Employee("Big Boss");
        Diff diff = javers.compare((Object)oldBoss, (Object)newBoss);
        Assertions.assertThat((List)diff.getChangesByType(ObjectRemoved.class)).hasSize(1000);
    }
}

