/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;

public abstract class ClientsClassDefinitionBuilder<T extends ClientsClassDefinitionBuilder> {
    private Class<?> clazz;
    private List<String> ignoredProperties = Collections.emptyList();
    private Optional<String> typeName = Optional.empty();

    ClientsClassDefinitionBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public T withIgnoredProperties(String ... ignoredProperties) {
        this.withIgnoredProperties(Lists.asList(ignoredProperties));
        return (T)this;
    }

    public T withIgnoredProperties(List<String> ignoredProperties) {
        Validate.argumentIsNotNull(ignoredProperties);
        this.ignoredProperties = ignoredProperties;
        return (T)this;
    }

    public T withTypeName(String typeName) {
        Validate.argumentIsNotNull(typeName);
        this.typeName = Optional.of(typeName);
        return (T)this;
    }

    public ClientsClassDefinition build() {
        throw new RuntimeException("not implemented");
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public Optional<String> getTypeName() {
        return this.typeName;
    }
}

