/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.Collection;
import java.util.List;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.snapshot.SnapshotDiffer;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.PreviousSnapshotsCalculator;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;

public class JaversExtendedRepository
implements JaversRepository {
    private final JaversRepository delegate;
    private final SnapshotDiffer snapshotDiffer;
    private final PreviousSnapshotsCalculator previousSnapshotsCalculator;

    public JaversExtendedRepository(JaversRepository delegate, SnapshotDiffer snapshotDiffer) {
        this.delegate = delegate;
        this.snapshotDiffer = snapshotDiffer;
        this.previousSnapshotsCalculator = new PreviousSnapshotsCalculator(new Function<Collection<SnapshotIdentifier>, List<CdoSnapshot>>(){

            @Override
            public List<CdoSnapshot> apply(Collection<SnapshotIdentifier> input) {
                return JaversExtendedRepository.this.getSnapshots(input);
            }
        });
    }

    public List<Change> getChangeHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        List<CdoSnapshot> snapshots = this.getStateHistory(globalId, queryParams);
        List<Change> changes = this.getChangesIntroducedBySnapshots(queryParams.newObjectChanges() ? snapshots : this.skipInitial(snapshots));
        return this.filterByPropertyName(changes, queryParams);
    }

    public List<Change> getChangeHistory(ManagedType givenClass, QueryParams queryParams) {
        Validate.argumentsAreNotNull(givenClass, queryParams);
        List<CdoSnapshot> snapshots = this.getStateHistory(givenClass, queryParams);
        List<Change> changes = this.getChangesIntroducedBySnapshots(queryParams.newObjectChanges() ? snapshots : this.skipInitial(snapshots));
        return this.filterByPropertyName(changes, queryParams);
    }

    public List<Change> getValueObjectChangeHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        List<CdoSnapshot> snapshots = this.getValueObjectStateHistory(ownerEntity, path, queryParams);
        return this.getChangesIntroducedBySnapshots(queryParams.newObjectChanges() ? snapshots : this.skipInitial(snapshots));
    }

    public List<Change> getChanges(boolean newObjects, QueryParams queryParams) {
        Validate.argumentsAreNotNull(queryParams);
        List<CdoSnapshot> snapshots = this.getSnapshots(queryParams);
        return this.getChangesIntroducedBySnapshots(newObjects ? snapshots : this.skipInitial(snapshots));
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        return this.delegate.getStateHistory(globalId, queryParams);
    }

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        return this.delegate.getValueObjectStateHistory(ownerEntity, path, queryParams);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.delegate.getLatest(globalId);
    }

    @Override
    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        Validate.argumentsAreNotNull(queryParams);
        return this.delegate.getSnapshots(queryParams);
    }

    @Override
    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        Validate.argumentIsNotNull(snapshotIdentifiers);
        return this.delegate.getSnapshots(snapshotIdentifiers);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(ManagedType givenClass, QueryParams queryParams) {
        return this.delegate.getStateHistory(givenClass, queryParams);
    }

    @Override
    public void persist(Commit commit) {
        this.delegate.persist(commit);
    }

    @Override
    public CommitId getHeadId() {
        return this.delegate.getHeadId();
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    @Override
    public void ensureSchema() {
        this.delegate.ensureSchema();
    }

    private List<Change> filterByPropertyName(List<Change> changes, final QueryParams queryParams) {
        if (queryParams.changedProperty().isEmpty()) {
            return changes;
        }
        return Lists.positiveFilter(changes, new Predicate<Change>(){

            @Override
            public boolean apply(Change input) {
                return input instanceof PropertyChange && ((PropertyChange)input).getPropertyName().equals(queryParams.changedProperty().get());
            }
        });
    }

    private List<CdoSnapshot> skipInitial(List<CdoSnapshot> snapshots) {
        return Lists.negativeFilter(snapshots, new Predicate<CdoSnapshot>(){

            @Override
            public boolean apply(CdoSnapshot snapshot) {
                return snapshot.isInitial();
            }
        });
    }

    private List<Change> getChangesIntroducedBySnapshots(List<CdoSnapshot> snapshots) {
        return this.snapshotDiffer.calculateDiffs(snapshots, this.previousSnapshotsCalculator.calculate(snapshots));
    }
}

