/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples;

import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.examples.model.Person;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.QueryBuilder;
import org.junit.Test;

public class BasicCommitExample {
    @Test
    public void shouldCommitToJaversRepository() {
        Javers javers = JaversBuilder.javers().build();
        Person robert = new Person("bob", "Robert Martin");
        javers.commit("user", (Object)robert);
        robert.setName("Robert C.");
        javers.commit("user", (Object)robert);
        List snapshots = javers.findSnapshots(QueryBuilder.byInstanceId((Object)"bob", Person.class).build());
        Assertions.assertThat((List)snapshots).hasSize(2);
    }

    @Test
    public void shouldListStateHistory() {
        Javers javers = JaversBuilder.javers().build();
        Person robert = new Person("bob", "Robert Martin");
        javers.commit("user", (Object)robert);
        robert.setName("Robert C.");
        javers.commit("user", (Object)robert);
        List snapshots = javers.findSnapshots(QueryBuilder.byInstanceId((Object)"bob", Person.class).limit(10).build());
        Assertions.assertThat((List)snapshots).hasSize(2);
        CdoSnapshot newState = (CdoSnapshot)snapshots.get(0);
        CdoSnapshot oldState = (CdoSnapshot)snapshots.get(1);
        Assertions.assertThat((Object)oldState.getPropertyValue("name")).isEqualTo((Object)"Robert Martin");
        Assertions.assertThat((Object)newState.getPropertyValue("name")).isEqualTo((Object)"Robert C.");
    }

    @Test
    public void shouldListChangeHistory() {
        Javers javers = JaversBuilder.javers().build();
        Person robert = new Person("bob", "Robert Martin");
        javers.commit("user", (Object)robert);
        robert.setName("Robert C.");
        javers.commit("user", (Object)robert);
        List changes = javers.findChanges(QueryBuilder.byInstanceId((Object)"bob", Person.class).build());
        Assertions.assertThat((List)changes).hasSize(1);
        ValueChange change = (ValueChange)changes.get(0);
        Assertions.assertThat((String)change.getPropertyName()).isEqualTo((Object)"name");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)"Robert Martin");
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)"Robert C.");
    }
}

