/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.date;

import org.javers.core.json.BasicStringTypeAdapter;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

class LocalDateTypeAdapter
extends BasicStringTypeAdapter<LocalDate> {
    private static final DateTimeFormatter ISO_DATE_FORMATTER = ISODateTimeFormat.date();

    LocalDateTypeAdapter() {
    }

    @Override
    public String serialize(LocalDate sourceValue) {
        return ISO_DATE_FORMATTER.print((ReadablePartial)sourceValue);
    }

    @Override
    public LocalDate deserialize(String serializedValue) {
        return ISO_DATE_FORMATTER.parseLocalDate(serializedValue);
    }

    @Override
    public Class getValueType() {
        return LocalDate.class;
    }
}

