/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ManagedType;

public final class CdoSnapshot
extends Cdo {
    private CommitMetadata commitMetadata;
    private final CdoSnapshotState state;
    private final SnapshotType type;
    private final List<String> changed;
    private final long version;

    CdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata, CdoSnapshotState state, SnapshotType type, List<String> changed, ManagedType managedType, long version) {
        super(globalId, managedType);
        Validate.argumentsAreNotNull(new Object[]{state, commitMetadata, type, managedType});
        this.state = state;
        this.commitMetadata = commitMetadata;
        this.type = type;
        this.changed = changed;
        this.version = version;
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.empty();
    }

    public int size() {
        return this.state.size();
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.state.getPropertyValue(propertyName);
    }

    @Override
    public Object getPropertyValue(Property property) {
        return this.state.getPropertyValue(property);
    }

    public List<String> getChanged() {
        return Collections.unmodifiableList(this.changed);
    }

    public boolean hasChangeAt(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return this.changed.contains(propertyName);
    }

    @Override
    public boolean isNull(Property property) {
        return this.state.isNull(property.getName());
    }

    public CommitId getCommitId() {
        return this.commitMetadata.getId();
    }

    public CommitMetadata getCommitMetadata() {
        return this.commitMetadata;
    }

    public boolean stateEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdoSnapshot other = (CdoSnapshot)o;
        return this.state.equals(other.state);
    }

    public CdoSnapshotState getState() {
        return this.state;
    }

    public boolean isInitial() {
        return this.type == SnapshotType.INITIAL;
    }

    public boolean isTerminal() {
        return this.type == SnapshotType.TERMINAL;
    }

    public SnapshotType getType() {
        return this.type;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Snapshot{commit:").append(this.getCommitMetadata().getId()).append(", ").append("id:").append(this.getGlobalId()).append(", ").append("version:").append(this.getVersion()).append(", ").append(this.getState() + "}");
        return stringBuilder.toString();
    }
}

