/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.FastManifestParser;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class JarUtils {
    public static boolean isJar(String path) {
        int len = path.length();
        int extIdx = len - 3;
        return len > 4 && path.charAt(len - 4) == '.' && (path.regionMatches(true, extIdx, "jar", 0, 3) || path.regionMatches(true, extIdx, "zip", 0, 3) || path.regionMatches(true, extIdx, "war", 0, 3) || path.regionMatches(true, extIdx, "car", 0, 3));
    }

    public static boolean isJREJar(File file, int ancestralScanDepth, ConcurrentHashMap<String, String> knownJREPaths, ConcurrentHashMap<String, String> knownNonJREPaths, LogNode log) {
        if (ancestralScanDepth == 0) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        String parentPathStr = parent.getPath();
        if (knownJREPaths.containsKey(parentPathStr)) {
            return true;
        }
        if (knownNonJREPaths.containsKey(parentPathStr)) {
            return false;
        }
        File rt = new File(parent, "jre/lib/rt.jar");
        if (!rt.exists() && !(rt = new File(parent, "lib/rt.jar")).exists()) {
            rt = new File(parent, "rt.jar");
        }
        boolean isJREJar = false;
        if (rt.exists()) {
            FastManifestParser manifest = new FastManifestParser(rt, log);
            if (manifest.isSystemJar) {
                isJREJar = true;
            }
        }
        if (!isJREJar) {
            isJREJar = JarUtils.isJREJar(parent, ancestralScanDepth - 1, knownJREPaths, knownNonJREPaths, log);
        }
        if (!isJREJar) {
            knownNonJREPaths.put(parentPathStr, parentPathStr);
        } else {
            knownJREPaths.put(parentPathStr, parentPathStr);
        }
        return isJREJar;
    }
}

