/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.cases;

import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.junit.Test;

public class Case250CharSequence {
    @Test
    public void shouldCompareTwoObjectsWithCharSequencePropertiesOfString() {
        Javers javers = JaversBuilder.javers().build();
        AvroAddress oldVersion = new AvroAddress("New York", "First Avenue");
        AvroAddress currentVersion = new AvroAddress("New York", "Second Avenue");
        Diff diff = javers.compare((Object)oldVersion, (Object)currentVersion);
        System.out.println(diff);
        ValueChange change = (ValueChange)diff.getChangesByType(ValueChange.class).get(0);
        Assertions.assertThat((List)diff.getChanges()).hasSize(1);
        Assertions.assertThat((String)change.getPropertyName()).isEqualTo((Object)"street");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)oldVersion.getStreet());
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)currentVersion.getStreet());
    }

    private static class AvroAddress {
        private final CharSequence city;
        private final CharSequence street;

        public AvroAddress(CharSequence city, CharSequence street) {
            this.city = city;
            this.street = street;
        }

        public CharSequence getCity() {
            return this.city;
        }

        public CharSequence getStreet() {
            return this.street;
        }
    }
}

