/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.cases;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.Id;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.junit.Test;

public class ChangedPropertyNamesForNullifiedValuesCase {
    @Test
    public void shouldCalculateChangedPropertyNamesForNullifiedValues() {
        Javers javers = JaversBuilder.javers().build();
        SimpleTypes obj = new SimpleTypes("1");
        javers.commit("anonymous", (Object)obj);
        obj.shortNumber = -1;
        javers.commit("anonymous", (Object)obj);
        CdoSnapshot s = (CdoSnapshot)javers.getLatestSnapshot((Object)"1", SimpleTypes.class).get();
        Assertions.assertThat((List)s.getChanged()).containsExactly((Object[])new String[]{"shortNumber"});
        obj.nullify();
        javers.commit("anonymous", (Object)obj);
        s = (CdoSnapshot)javers.getLatestSnapshot((Object)"1", SimpleTypes.class).get();
        Assertions.assertThat((List)s.getChanged()).hasSize(11);
    }

    static class SimpleTypes {
        @Id
        String id;
        Date date = new Date();
        java.sql.Date dateSql = new java.sql.Date(this.date.getTime());
        Timestamp ts = new Timestamp(this.date.getTime());
        String text = "test";
        Boolean bool = true;
        Long longNumber = 1L;
        Integer integerNumber = 1;
        Short shortNumber = 1;
        Double doubleNumber = 1.0;
        Float floatNumber = Float.valueOf(1.0f);
        BigDecimal bigDecimalNumber = BigDecimal.ONE;
        byte byteFiled = 1;
        TestEnum testEnum = TestEnum.ONE;

        public SimpleTypes(String id) {
            this.id = id;
        }

        public void nullify() {
            this.date = null;
            this.ts = null;
            this.text = null;
            this.bool = null;
            this.longNumber = null;
            this.integerNumber = null;
            this.shortNumber = null;
            this.doubleNumber = null;
            this.floatNumber = null;
            this.bigDecimalNumber = null;
            this.testEnum = null;
        }

        static enum TestEnum {
            ONE,
            TWO;

        }
    }
}

