/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Id;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.javers.core.examples.model.Address;

public class Employee {
    @Id
    private String name;
    private String position;
    private int salary;
    private Employee boss;
    private List<Employee> subordinates = new ArrayList<Employee>();
    private Address primaryAddress;
    private Address postalAddress;
    private int age;

    public Employee() {
    }

    public Employee(String name) {
        this(name, 10000);
    }

    public Employee(String name, int salary) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
        this.salary = salary;
    }

    public Employee(String name, int salary, String position) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)position);
        this.name = name;
        this.salary = salary;
        this.position = position;
    }

    public Employee addSubordinate(Employee employee) {
        Preconditions.checkNotNull((Object)employee);
        employee.boss = this;
        this.subordinates.add(employee);
        return this;
    }

    public Employee addSubordinates(Employee ... employees) {
        Preconditions.checkNotNull((Object)employees);
        for (Employee e : employees) {
            this.addSubordinate(e);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPosition() {
        return this.position;
    }

    public Employee getBoss() {
        return this.boss;
    }

    public int getSalary() {
        return this.salary;
    }

    public int getAge() {
        return this.age;
    }

    public Address getPrimaryAddress() {
        return this.primaryAddress;
    }

    public List<Employee> getSubordinates() {
        return Collections.unmodifiableList(this.subordinates);
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Employee)) {
            return false;
        }
        Employee that = (Employee)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("salary", this.salary).append("boss", (Object)(this.boss != null ? this.boss.name : "")).append("subordinates", this.subordinates.size()).toString();
    }
}

