package org.javers.core;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.*;

/**
 * @deprecated since 2.8.0
 */
@Deprecated
public class IdBuilder {
    private final GlobalIdFactory globalIdFactory;

    private GlobalId owner;

    public IdBuilder(GlobalIdFactory globalIdFactory) {
        this.globalIdFactory = globalIdFactory;
    }

    public IdBuilder withUnboundedOwner(Class ownerValueObjectClass) {
        owner = unboundedValueObjectId(ownerValueObjectClass);
        return this;
    }

    public IdBuilder withOwner(Object localId, Class ownerEntityClass) {
        owner = instanceId(localId, ownerEntityClass);
        return this;
    }

    public ValueObjectId voId(String path){
        Validate.conditionFulfilled(owner != null, "call withOwner() first");
        return globalIdFactory.createValueObjectIdFromPath(owner, path);
    }

    public InstanceId instanceId(Object instance){
        Validate.argumentsAreNotNull(instance);

        return globalIdFactory.createInstanceId(instance);
    }

    public UnboundedValueObjectId unboundedValueObjectId(Class valueObjectClass){
        Validate.argumentsAreNotNull(valueObjectClass);
        return globalIdFactory.createUnboundedValueObjectId(valueObjectClass);

    }

    public InstanceId instanceId(Object localId, Class entityClass){
        Validate.argumentsAreNotNull(localId, entityClass);
        return  globalIdFactory.createInstanceId(localId, entityClass);
    }
}
